-- existe existencia de un producto-color en bodegas
SELECT /* existe existencia el producto - color indicado*/
    IF(existencia_rollos<>0 OR existencia_quantity<>0, 'Con Existencia', 'Sin Existencia')
FROM producto_bodega WHERE producto_general_id='?' AND color_id='?';

-- Orden usual o por default de colores
SELECT color_id, color FROM color ORDER BY orden, color;

-- reporte de ventas
SELECT iac_usr_id, color_id
FROM pedido_recomienda pr
         JOIN pedido_recomienda_items pri on pr.pedido_recomienda_id = pri.pedido_recomienda_id
WHERE pr.activo = 'Si' AND EXISTS (
    SELECT 1
    FROM producto_color pc -- ...
);
-- Colores para china
SELECT c.color_id, c.color
FROM pedido_recomienda pr
         JOIN pedido_recomienda_items pri on pr.pedido_recomienda_id = pri.pedido_recomienda_id
         JOIN color c on pri.color_id = c.color_id
WHERE pr.activo = 'Si' AND producto_general_id=
UNION distinct
SELECT c2.color_id, c2.color
FROM producto_color pc
         JOIN color c2 on pc.color_id = c2.color_id
WHERE pc.activo = 'Si' AND producto_general_id=
ORDER BY 1;


SELECT /*ProductoGeneralUtil::coloresPorProductoGet*/
    pc.producto_general_id, pc.color_id, c.color,pc.activo, pc.prohibido,
    (SELECT ' (Con ∃)'
     FROM producto_bodega pb
     WHERE pb.producto_general_id=pc.producto_general_id AND pb.color_id=pc.color_id AND
         (pb.existencia_quantity<>0 OR pb.existencia_rollos <> 0)
     LIMIT 1
    ) as con_existencia,
    IF(
                (SELECT SUM(ABS(pb.existencia_rollos) + ABS(pb.existencia_quantity) )
                 FROM producto_bodega pb
                 WHERE pb.producto_general_id=pc.producto_general_id AND pb.color_id=pc.color_id
                ) = 0,'  (Sin ∃)', null) as sin_existencia
FROM producto_color pc
         JOIN color c on pc.color_id = c.color_id
ORDER BY c.color;


